<style>
    .penjualan-item {
        display: block;
        height: 350px;
        overflow: auto;
    }

    .thead-item,
    .penjualan-item tr {
        display: table;
        width: 100%;
        table-layout: fixed;
        /* even columns width , fix width of table too*/
    }

    thead {
        width: calc(100% - 1em)
            /* scrollbar is average 1em/16px width, remove it from thead width */
    }

    table {
        width: 400px;
    }

    .font_small {
        font-size: 14px;
    }
</style>

<form action="<?php echo base_url('penjualan/proses') ?>" method="POST" class="form-penjualan" enctype="multipart/form-data">
    <div class="row">
        <div class="col-md-5">
            <div class="box box-danger">
                <div class="box-header with-border">
                    <div class="pull-left">
                        Tanggal : <?php echo date('d-m-Y') ?>
                    </div>
                    <div class="pull-right">
                        Kasir : <?php echo $this->session->userdata('nama_petugas'); ?>
                    </div>
                </div>
                <div class="box-body">
                    <input type="hidden" name="id_petugas" value="<?php echo $this->session->userdata('id_petugas'); ?>">
                    <input type="hidden" name="faktur_penjualan" value="<?php echo $faktur_penjualan ?>">
                    <input type="hidden" class="member" name="member" value="0">
                    <input type="hidden" name="id_service" value="">
                    <div class="pelanggan_baru"></div>
                    <div class="form-group">
                        <div class="input-group input-group">
                            <input type="text" class="form-control pelanggan_umum" name="pelanggan_umum" placeholder="Pelanggan Umum">
                            <span class="input-group-btn">
                                <button type="button" class="btn btn-info btn-flat"><i class="fa fa-barcode"></i></button>
                            </span>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-group input-group">
                            <select required="" name="id_pelanggan" id="id_pelanggan" class="form-control select2 pelanggan pelanggan-wrapper">
                                <?php foreach ($pelanggan as $row) : ?>
                                    <option value="<?php echo $row['id_pelanggan'] ?>">
                                        <?php echo $row['nama_pelanggan'] ?>
                                    </option>
                                <?php endforeach ?>
                            </select>
                            <span class="input-group-btn">
                                <button type="button" class="btn btn-info btn-flat"><i class="fa fa-users"></i></button>
                            </span>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-group input-group">
                            <select required="" name="id_karyawan" id="id_karyawan" class="form-control select2 karyawan karyawan-wrapper" width="100%">
                                <?php foreach ($karyawan as $row) : ?>
                                    <option <?php echo $this->session->userdata('id_karyawan') == $row['id_karyawan'] ? 'selected' : '' ?> value="<?php echo $row['id_karyawan'] ?>"><?php echo $row['nama_karyawan'] ?></option>
                                <?php endforeach ?>
                            </select>
                            <span class="input-group-btn">
                                <button type="button" class="btn btn-info btn-flat"><i class="fa fa-users"></i></button>
                            </span>
                        </div>
                    </div>
                      <div class="form-group">
                        <div class="input-group input-group">
                            <input type="text" class="form-control no_pesanan" name="no_pesanan" placeholder="No Pesanan" autocomplete="off">
                            <span class="input-group-btn">
                                <button type="button" class="btn btn-info btn-flat"><i class="fa fa-telegram"></i></button>
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <div class="form-group <?php if (form_error('barcode')) echo 'has-error' ?>">
                                    <input type="text" id="barcode" name="barcode" class="form-control barcode" placeholder="Barcode" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-10">
                            <input type="text" class="form-control qty_brg qty_focus" placeholder="Qty">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="thead-item">
                                    <tr>
                                        <th width="30%">Nama</th>
                                        <th>Qty</th>
                                        <th>Harga</th>
                                        <th>Golongan</th>
                                        <th>Subtotal</th>
                                        <th><i class="fa fa-gear"></i></th>
                                    </tr>
                                </thead>
                                <tbody class="penjualan-item">

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <table class="table">
                    <tr>
                        <th>Total Item</th>
                        <td colspan="2"><input readonly="" type="text" class="form-control total_item" name="total_item" value="0"></td>
                    </tr>
                </table>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table">
                                <tr>
                                    <th>Diskon (%) | Potongan</th>
                                    <td><input type="text" class="form-control diskon" name="diskon" autocomplete="off" value="0"></td>
                                    <td><input autocomplete="off" type="text" class="form-control potongan" name="potongan" autocomplete="off" value="0"></td>
                                    <input type="hidden" name="potongan_rp" class="potongan_rp">
                                </tr>
                                <tr>
                                    <th>Jumlah Bayar</th>
                                    <td colspan="2"><input readonly="" type="text" class="form-control jumlah_bayar" name="jumlah_bayar" value="Rp. 0"></td>
                                </tr>
                                <tr>
                                    <th>Metode</th>
                                    <td colspan="2">
                                        <select name="metode_pembayaran" id="metode_pembayaran" class="form-control metode_pembayaran">
                                            <option value="Cash" selected>Cash</option>
                                            <option value="Kredit">Kredit</option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Jatuh Tempo</th>
                                    <td colspan="2"><input type="date" name="tgl_jatuh_tempo" id="tgl_jatuh_tempo" class="form-control"></td>
                                </tr>
                                <tr>
                                    <th><input type="checkbox" name="kirim" id="kirim"> <label for="kirim">Kirim</label> </th>
                                </tr>
                                <tr class="ship_nama">
                                    <th>Nama</th>
                                    <td colspan="2"><input type="text" placeholder="Nama" name="nama_pengiriman" id="nama_pengiriman" class="form-control"></td>
                                </tr>
                                <tr class="ship_alamat">
                                    <th>Alamat</th>
                                    <td colspan="2"><input type="text" placeholder="Alamat" name="alamat_pengiriman" id="alamat_pengiriman" class="form-control"></td>
                                </tr>
                                <tr>
                                    <th>Cash</th>
                                    <td colspan="2"><input placeholder="Cash" required="true" type="text" autocomplete="off" class="form-control cash" name="cash"></td>
                                </tr>
                                <input type="hidden" name="no_kredit" value="">
                                <input type="hidden" name="lampiran" value="">
                                <input type="hidden" name="no_debit" value="">
                                <tr>
                                    <th>Kembalian</th>
                                    <td colspan="2"><input readonly="" type="text" class="form-control kembalian" style="font-size: 20px"></td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                        <button type="submit" class="btn btn-primary btn-block btn-flat konfirmasi-penjualan">Konfirmasi</button>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                        <button type="submit" class="btn btn-warning btn-block btn-flat hold-penjualan">Hold</button>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                        <button type="submit" class="btn btn-danger btn-block btn-flat batal">Batal</button>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-7">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-danger">
                        <div class="box-header with-border">
                            <div class="pull-left">
                                <?php echo $faktur_penjualan ?>
                            </div>
                            <div class="pull-right">
                                <input type="text" class="total_jumlah_bayar" style="text-align: right;border:none; font-size: 50px" value="Rp. 0">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-danger">
                        <div class="box-body with-border">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive">
                                        <table class="table" id="table-cari-barang" width="100%">
                                            <thead>
                                                <tr>
                                                    <th>Kode</th>
                                                    <th>Nama Barang</th>
                                                    <th>1</th>
                                                    <th>2</th>
                                                    <th>3</th>
                                                    <th>4</th>
                                                    <th>Stok</th>
                                                    <th>Aksi</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
    <?php

    $pengaturan = $this->db->get('pengaturan')->row_array();

    echo "const pengaturan = " . json_encode($pengaturan) . "; ";

    echo "const judul = '" . $judul . "';";

    ?>
</script>
